
const { verifyToken } = require('@helpers/util-jwt');
const {
    getDocs,
} = require('@helpers/factoryFN');
// const { catchAsync } = require('../../../helpers/commonFN');
const { User } = require('../MVC/user/model/user');
const { _res } = require('@helpers/util-response');

const _ = require('lodash');
const { getSession, cacheInstance } = require('../helpers/util-Cache');
// helper Functions Starts

exports.validTokenStr = token => {
    if (!token.startsWith('Bearer ')) return false;
    return token.split(' ')[1];
};


exports.protect = async (req, res, next) => {
    try {
        // 1) get user token and validate it, as it should be validate
        let { authorization: token } = req.headers;
        if (!token || !this.validTokenStr(token)) return _res({ res });

        token = this.validTokenStr(token); // validTokenStr() ==> get rid the Bearer in token
        const verified = await verifyToken(token); // await promisify(jwt.verify)(
        // token,
        // config.AUTH.jwt.secret
        // );

        if (!verified)
            return _res({
                res,
                status: true,
                message: 'Authorization failed invalid token',
                code: 401
            });


        //logic to show return error
        const { _id: id, iat } = verified
        const reqCopy = { ...req, params: { id } };

        // check the mean while when user loggedIn. if the Admin delete this user,
        // then it'll no longer access the app routes

        //check in session-cache
        let cache = await getSession(cacheInstance["session-cache"], token)
        if (!cache) return _res({
            res,
            status: true,
            message: 'Authorization failed invalid token',
            code: 401
        });

        const user = await getDocs(User, { returnDoc: true, populate: { path: 'role', select: 'title public' }, single: true })(reqCopy); //rd => return Doc
        if (!user.status)
            return _res({ res, status: true, message: 'something went wrong', code: 401 });
        if (!user.data)
            return _res({
                res,
                status: true,
                message: 'Your provided token is not valid, please provide a valid token',
                code: 401
            });

        // check if user change the password after the token is issued
        if (user.data.changePasswordAfter(iat))
            return _res({
                res,
                status: true,
                message: 'your password has been changed, Please log in again',
                code: 401
            });

        req.user = user.data;
        req.userId = user.data._id.toString()
        next();
    } catch (e) {
        return _res({ res, status: true, message: e.message, code: 500 });
    }
};