/**
 * Created by hassan.raza on 02/09/2024.
 */
const cacheHelper = require('./util-Cache'),
  { AUTH } = require('../config'),
  randomstring = require('randomstring'),
  jwtHelper = require('./util-jwt');
/**
 * @function @emailAttributerFormatter
 * @description return regex pattern of email attribute
 * @requires emailAttribute(String)
 * */
exports.emailAttributerFormatter = emailAttribute => {
  let regexVariable = '\\$\\$' + emailAttribute + '\\$\\$';
  return new RegExp(regexVariable, 'g');
};

/**
 * @function @generateJWTToken
 * @description return jwt token
 * @requires auth(Object)
 * */

exports.generateJWTToken = async auth => {
  var JWT_object = {
    email: auth.email,
    _id: auth._id
  };

  var token = jwtHelper.generateToken(
    JWT_object,
    AUTH.jwt.expiresIn
  );
  var temp_obj = {
    _id: auth._id
  };

  await cacheHelper.initSession(
    cacheHelper.cacheInstance['session-cache'],
    token,
    temp_obj
  );

  return token;
};

//generate 6 digit numeric code.
exports.generateCode = async (obj, type, length, session) => {
  //generate token
  var token = jwtHelper.generateToken(obj, '60');
  // get code of 6 numeric
  let code = randomstring.generate({
    length: length,
    charset: type
  });
  //cacheSession Created in db and node cache.
  await cacheHelper.initSession(
    cacheHelper.cacheInstance[session],
    code,
    token
  );

  return code;
};
exports.catchAsync = async fn => {
  return (req, res, next) => {
    fn(req, res, next).catch(next);
  };
};
