/** @format */

const slugGenerator = (txt = '', uniqueTimestamp,unique) => {
  if(unique)
   return `${txt.replace(/\s+/g, '-').toLowerCase()}-${uniqueTimestamp}`;
  else
   return `${txt.replace(/\s+/g, '-').toLowerCase()}`;
}

const insertSlug = (field, type,unique = true ) => (req, res, next) => {
  if (field in req.body) {
    let timestamp = null;
    if (type === 'update' && req.body.slug) {
      timestamp = req.body.slug.substring(
        req.body.slug.lastIndexOf('-') + 1,
        req.body.slug.length
      );
    } else timestamp = new Date().getTime();

    req.body.slug = slugGenerator(req.body[field], timestamp,unique);
  }
  next();
};

const catchAsync = async fn => {
  return async (req, res, next) => {
    fn(req, res, next).catch(next);
  };
};

module.exports = { catchAsync, insertSlug };
