/** @format */

const { routesHandler } = require('../../../helpers/util-generic-functions');
const {
  signup,
  login,
  getUser,
  logout,
  deleteUser,
  updatePassword,
  forgotPassword,
  resetPassword,
  getAllUsers,
  updateUser
} = require('../controller/user');
const { upload, prepareAndUpload } = require('../../../middleware/fileUploadMiddleware');
const { protect } = require('../../../middleware/authenticationMiddleware');

const user = router => {
  // Authentication Routes
  router.post(`/auth/signup`, upload.single('avatar'), prepareAndUpload, routesHandler(signup));
  router.post(`/auth/login`, routesHandler(login));
  router.post(`/auth/logout`, protect, routesHandler(logout));
  router.post(`/auth/forgotpassword`, routesHandler(forgotPassword));
  router.put(`/auth/resetpassword/:token`, routesHandler(resetPassword));

  // update profiles
  router.post(`/auth/updatepassword`, protect, routesHandler(updatePassword));
  // router.post(`/auth/updateme`, routesHandler(updatePassword));

  // users Routes
  router.get(`/users`, protect, routesHandler(getAllUsers));
  router.get(`/user/:id`, protect, routesHandler(getUser));
  router.put(
    `/user/:id`,
    protect,
    upload.single('avatar'),
    routesHandler(updateUser)
  );
  router.delete(`/user/:id`, protect, routesHandler(deleteUser));
};

module.exports = user;
