/** @format */

const { routesHandler } = require('../../../helpers/util-generic-functions');
const {
  createStory,
  updateStory,
  getStory,
  getAllStory,
  deleteStory
} = require('../controller/story');
const { upload, prepareAndUpload } = require('../../../middleware/fileUploadMiddleware');
const { protect } = require('../../../middleware/authenticationMiddleware');

const story = router => {
  // Story Routes
  router.post(`/story/create`, protect, upload.single('media'), prepareAndUpload, routesHandler(createStory));
  router.put(`/story/update/:id`, protect, upload.single('media'), prepareAndUpload, routesHandler(updateStory));
  router.get(`/story/:id`, protect, routesHandler(getStory));
  router.get(`/storys`, protect, routesHandler(getAllStory));
  router.put(`/story/delete/:id`, protect, routesHandler(deleteStory));

};

module.exports = story;
