/** @format */

const { routesHandler } = require('../../../helpers/util-generic-functions');
const {
  getMyProfile,
  getProfile,
  followUser,
  unfollowUser,
  getFollowers,
  getFollowings
} = require('../controller/profile');
const { upload, prepareAndUpload } = require('../../../middleware/fileUploadMiddleware');
const { protect } = require('../../../middleware/authenticationMiddleware');

const profile = router => {
  // Profile Routes
  router.get(`/profile/me`, protect, routesHandler(getMyProfile));
  router.get(`/profile/:id`, protect, routesHandler(getProfile));

  router.post(`/follow`, protect, routesHandler(followUser));
  router.post(`/unfollow`, protect, routesHandler(unfollowUser));
  router.get(`/followers`, protect, routesHandler(getFollowers));
  router.get(`/followings`, protect, routesHandler(getFollowings));

};

module.exports = profile;
