/** @format */

const { routesHandler } = require('../../../helpers/util-generic-functions');
const {
  createPost,
  updatePost,
  getPost,
  getAllPost,
  deletePost
} = require('../controller/post');
const { upload, prepareAndUpload } = require('../../../middleware/fileUploadMiddleware');
const { protect } = require('../../../middleware/authenticationMiddleware');

const post = router => {
  // Post Routes
  router.post(`/post/create`, protect, upload.single('media'), prepareAndUpload, routesHandler(createPost));
  router.put(`/post/update/:id`, protect, upload.single('media'), prepareAndUpload, routesHandler(updatePost));
  router.get(`/post/:id`, protect, routesHandler(getPost));
  router.get(`/posts`, protect, routesHandler(getAllPost));
  router.put(`/post/delete/:id`, protect, routesHandler(deletePost));

};

module.exports = post;
