/* eslint-disable no-restricted-syntax */
/** @format */

const mongoose = require('mongoose');

const { convert } = require('joigoose')(mongoose);
const Joi = require('joi');
const baseSchema = require('../../baseSchema');

const likeJoigooseSchema = Joi.object({
  user: Joi.string().required().meta({
    _mongoose: { type: 'ObjectId', ref: 'User' }
  }),
  itemId: Joi.string().required().meta({
    _mongoose: { type: 'ObjectId', ref: 'Post' }
  }),
  itemType: Joi.string().required().valid('Post', 'Comment'),
  ...baseSchema
});

let likeSchema = convert(likeJoigooseSchema);

likeSchema.user = {
  type: mongoose.Schema.Types.ObjectId,
  ref: 'User'
};

likeSchema.itemId = {
  type: mongoose.Schema.Types.ObjectId,
  ref: 'Post'
};


likeSchema = new mongoose.Schema(likeSchema);





const Like = mongoose.model('Like', likeSchema);



// validate the like input by passing it to joigoose schema
const validateLike = likeData => likeJoigooseSchema.validate(likeData);

module.exports = {
  Like,
  validateLike
};
