/** @format */

const { routesHandler } = require('../../../helpers/util-generic-functions');
const {
  createComment,
  removeComment,
  getComments
} = require('../controller/comment');
const { protect } = require('../../../middleware/authenticationMiddleware');

const story = router => {
  // Comment Routes
  router.post(`/comment/create`, protect, routesHandler(createComment));
  router.put(`/comment/remove/:id`, protect, routesHandler(removeComment));
  router.get(`/comments`, protect, routesHandler(getComments));
};

module.exports = story;
