/** @format */
/** @format */

const {
  createDoc,
  getDocs
} = require('@helpers/factoryFN');
const { validateComment, Comment } = require('../model/comment');
const { _responseWrapper } = require('@helpers/util-response');

exports.createComment = async (req) => {
  req.body['user'] = req.userId
  const comment = await createDoc(Comment, {
    returnDoc: true,
    validateFN: validateComment
  })(req);

  if (!comment.status) {
    if (comment.statusCode === 400)
      return comment
    return _responseWrapper(true, comment.error.message, 400);
  }

  return _responseWrapper(false, `You have commentd the ${req.body.itemType}`, 201, {
    data: comment.data
  });
}

exports.removeComment = async (req) => {
  let removed = await Comment.findByIdAndDelete(req.params.id)
  if (removed)
    return _responseWrapper(false, `You have remove the comment`, 200)
  else
    return _responseWrapper(true, `Comment not found`, 404)
}

exports.getComments = async (req) => {
  let query = {
    itemId: req.body.itemId
  }
  let populate = {
    path: 'user',
    model: 'User',
    select: 'name avatar'
  }
  let select = '-_id -itemId -itemType -createdBy -createdAt -__v -isDeleted'
  return await getDocs(Comment, { query, populate, select })(req)
}
