/** @format */
/** @format */
const { ObjectId } = require('mongoose').Types;
const {
  createDoc,
  getDocs,
  deleteDoc
} = require('@helpers/factoryFN');
const { validateMessage, Message } = require('../model/message');
const { _responseWrapper } = require('@helpers/util-response');
const {
  baseUrlGenerator
} = require('@middleware/fileUploadMiddleware');

exports.createMessage = async req => {
  try {
    if (req.files) req.body['media'] = [baseUrlGenerator(req)];
    else delete req.body['media'];

    if (!req.file && (!req.body.content || req.body.content == ''))
      return _responseWrapper(true, 'Content is required', 400);

    req.body['sender'] = req.userId;
    return await createDoc(Message, {
      returnDoc: true,
      validateFN: validateMessage
    })(req);

  } catch (error) {
    console.log('error', error);
    return _responseWrapper(true, error.message, error.statusCode);
  }
};

exports.getMessages = async req => {
  let { chatId } = req.query;
  if (!chatId) return _responseWrapper.errorResponse('Chat ID is required', 400);
  return await getDocs(Message, { query: { chat: chatId } })(req);
};

exports.deleteMessage = req => deleteDoc(Message)(req);