/** @format */
/** @format */

const {
  createDoc,
  getDocs,
  updateDoc,
  deleteDoc
} = require('@helpers/factoryFN');
const { validateChat, Chat } = require('../model/chat');
const { _responseWrapper } = require('@helpers/util-response');




exports.createChat = async req => {
  try {
    const existingChat = await Chat.findOne({
      participants: { $all: [req.userId, req.body.userId] },
      isDeleted: false
    });

    if (existingChat) {
      return _responseWrapper(true, 'Chat already exists', 400);
    }

    req.body.participants = [req.userId, req.body.userId];
    delete req.body.userId;
    return await createDoc(Chat, { returnDoc: true, validateFN: validateChat })(req);

  } catch (error) {
    console.log('error', error.message);
    return _responseWrapper(true, error.message, error.statusCode);
  }
};

exports.getAllChats = async req => {
  try {
    let restParams = {
      query: {
        participants: { $in: [req.userId] }
      }
    }

    return await getDocs(Chat, restParams)(req);
  } catch (error) {
    console.log('error', error.message);
    return _responseWrapper(true, error.message, error.statusCode);
  }
};

exports.getChat = async req => {
  try {
    return await getDocs(Chat)(req);
  } catch (err) {
    console.log(err)
  }
};

exports.deleteChat = deleteDoc(Chat);

exports.updateChat = async req => {
  try {
    const { accepted = false } = req.body;

    const chat = await Chat.findById(req.params.id);

    if (!chat || chat.accepted) {
      return _responseWrapper(true, 'Chat not found or already accepted', 404);
    }

    req.body.isRequest = !accepted;

    return await updateDoc(Chat)(req);
  } catch (error) {
    console.log('error', error.message);
    return _responseWrapper(true, error.message, error.statusCode);
  }
};
