/** @format */
const Joi = require('joi');
const mongoose = require('mongoose');

const { Schema, model } = mongoose;
const { convert } = require('joigoose')(mongoose);
const baseSchema = require('../../baseSchema');

const joiCacheSchema = Joi.object({
  instance: Joi.string().required(),
  key: Joi.string().required(),
  value: Joi.object().required(),
  ...baseSchema
});

let cacheSchema = convert(joiCacheSchema);
cacheSchema = new Schema(cacheSchema);

const Cache = model('Cache', cacheSchema);

const validateCache = cache => joiCacheSchema.validate(cache);

module.exports = {
  Cache,
  validateCache
};
