const nodemailer = require('nodemailer');
const { EMAIL_CONFIG } = require('@root/config');

exports.sendEmail = async ({ to, subject, text, from = `"${EMAIL_CONFIG.sender}" <${EMAIL_CONFIG.senderEmail}>` }) => {
  const transport = nodemailer.createTransport({
    // service: 'Gmail',
    port: EMAIL_CONFIG.port,
    host: EMAIL_CONFIG.host,//'smtp.gmail.com',
    secure: false,
    auth: {
      user: EMAIL_CONFIG.email,
      pass: EMAIL_CONFIG.password
    },
  });

  const options = {
    to,
    from,
    subject,
    text
    // html
  };
  // console.log("options", options)

  let result = await transport.sendMail(options);
};

exports.isValidEmail = email => {
  const re = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
  return re.test(String(email).toLowerCase());
};
