/**
 *  Created by hassan.raza on 04/09/2024.
 */

/*
 * Util-response.js
 */

const _ = require('lodash');

const ResponseWrapper = (status, message, statusCode, data = {}) => {
  const _res = {
    response: {
      status: status,
      message: message
    },
    statusCode: statusCode
  };
  if (message === 'requiredAll')
    _res.response.message = 'Please fill all the required fields';

  if (message === 'emailErr')
    _res.response.message = 'Please Provide a valid email address';

  if (message === 'fetchSuccess')
    _res.response.message = 'Fetched successfully';

  if (message === 'createSuccess')
    _res.response.message = 'Created successfully';

  if (message === 'updateSuccess')
    _res.response.message = 'Updated successfully';

  if (message === 'removeSuccess')
    _res.response.message = 'Removed successfully';

  if (message === 'alreadyExist')
    _res.response.message = 'Data is already exist';

  if (message === 'alreadyExistPin')
    _res.response.message = 'One post is already pined';

  if (message === 'EmailNotSend') _res.response.message = 'Somthing went wrong';

  if (message === 'LoginSuccess')
    _res.response.message = 'User Login Successfully';

  if (message === 'notFound') _res.response.message = 'Data not found';

  if ((data && Object.keys(data).length) || Array.isArray(data)) {
    _res.response.data = data.data;
    if (data.data.length && data.count) _res.response.count = data.count;
  }

  return _res;
};

const DataOmit = (data, omitArray) => {
  data.data = _.omit(data.data.toObject(), omitArray);
  return data;
};

const _res = (rest = {}) => {
  const {
    status = true,
    message = 'Authorization header or token is missing.',
    code = 401,
    res
  } = rest;
  res.status(code).json({
    response: {
      status,
      message
    },
    statusCode: code
  });
};
module.exports = {
  _responseWrapper: ResponseWrapper,
  _dataOmit: DataOmit,
  _res
};
