/* eslint-disable guard-for-in */
/* eslint-disable no-await-in-loop */
/* eslint-disable import/no-unresolved */
/* eslint-disable node/no-missing-require */

const NodeCache = require('node-cache');

const sessionCache = new NodeCache({ stdTTL: 0, checkperiod: 0 });
const accountVerificationCache = new NodeCache({
  stdTTL: 3600,
  checkperiod: 60
});
const CacheDB = require('../MVC/cache/controller/cache');
const jwtHelper = require('./util-jwt');
const { AUTH } = require('../config');

global.sessionCache = sessionCache;

const cacheInstance = {
  'session-cache': {
    title: 'session-cache',
    instance: sessionCache
  },
  'account-verification-cache': {
    title: 'account-verification-cache',
    instance: accountVerificationCache
  }
};

/*
 * =====================================================================
 * ------------------------ UTIL CACHE METHODS -------------------------
 * =====================================================================
 * */

const getSession = async (cache, key) => {
  const cacheResponse = await cache.instance.get(key);
  if (!cacheResponse) {
    console.log(`${cache.title}: Key not Found!`);
    return null;
  }
  return cacheResponse;
};

const removeSession = async (cache, key) => {
  const removeResponse = await cache.instance.del(key);

  if (removeResponse) {
    await CacheDB.removeCacheFN(key);
    console.log(`${cache.title}: Session Expire Successfully.`);
    return true;
  }
  console.log(`${cache}: Operation failed, cache not exists.${removeResponse}`);
  return false;
};

const addSession = async (cache, token, id) => {
  const cacheAdded = cache.instance.set(token, id);
  if (cacheAdded) {
    const cacheCreated = await CacheDB.addCacheFN(cache.title, token, id);
    if (cacheCreated.response.status)
      console.log(`${cache.title}: ${cacheCreated.response.message}`);
    else console.log(`${cache.title}: ${cacheCreated.response.message}`);
  }
};

const sessionKeys = () => {
  sessionCache.keys((err, mykeys) => {
    if (!err) {
      console.log('cache Keys: ', mykeys);
    }
  });
};

//refresh token cache socket
const refreshTokenCache = (data, rootCallback) => {
  const isExpired = jwtHelper.verifyToken(data.accessToken);
  if (!isExpired) {
    const newToken = jwtHelper.generateToken(
      { registerId: data.userId },
      AUTH.jwt.expiresIn
    );
    addSession(cacheInstance['session-cache'], newToken, data.userId);
    data.accessToken = newToken;
    rootCallback(data);
  }
};

//restoreCache
const restoreCache = async () => {
  const cached = await CacheDB.getCacheFN();
  if (cached.response.status) {
    const { data } = cached.response;
    // eslint-disable-next-line no-restricted-syntax
    for (const i in data) {
      const jwt = await jwtHelper.verifyToken(data[i].key);
      if (!jwt) await CacheDB.removeCacheFN(data[i].key);
      await cacheInstance[data[i].instance].instance.set(
        data[i].key,
        data[i].value
      );
    }
    console.log('Cache Restored Successfully');
  }
};

//DIRECT CACHE FUNCTIONS
const removeFromSession = (key, callback) => {
  sessionCache.del(key, (err, res) => {
    if (!err) {
      callback(null, res);
    } else {
      callback(err, null);
    }
  });
};

/*
 * =====================================================================
 * ------------------------- UTIL CACHE EVENTS -------------------------
 * =====================================================================
 * */

/**
 * @event expired - accountVerificationCache
 * @description Fired when a key expires. Will return the key and value as callback argument.
 * */
accountVerificationCache.on('expired', (key, value) => {
  CacheDB.removeCacheFN(key, () => {
    // success
  });
});

/**
 * @event expired - sessionCache
 * @description Fired when a key expires. Will return the key and value as callback argument.
 * */
sessionCache.on('expired', (key, value) => {
  CacheDB.removeCacheFN(key, () => {
    // success
  });
});

module.exports = {
  cacheInstance,
  initSession: addSession,
  getSession,
  removeSession,
  sessionKeys,
  restoreCache,
  refreshTokenCache,
  removeFromSessionCache: removeFromSession
};
