
const env = process.env.NODE_ENV;

let PORT = process.env.DEVELOPMENT_PORT
let API_VERSION = process.env.DEVELOPMENT_API_VERSION
let DATABASE_URL = process.env.DEVELOPMENT_DATABASE_URL
let DATABASE_PORT = process.env.DEVELOPMENT_DATABASE_PORT
let DATABASE_NAME = process.env.DEVELOPMENT_DATABASE_NAME
let DATABASE_USER = process.env.DEVELOPMENT_DATABASE_USER
let DATABASE_PASSWORD = process.env.DEVELOPMENT_DATABASE_PASSWORD
let CLOUD_NAME = process.env.DEVELOPMENT_CLOUD_NAME
let CLOUD_API_SECRET = process.env.DEVELOPMENT_CLOUD_API_SECRET
let CLOUD_API_KEY = process.env.DEVELOPMENT_CLOUD_API_KEY



if (env === 'production') {
  PORT = process.env.PRODUCTION_PORT
  API_VERSION = process.env.PRODUCTION_API_VERSION
  DATABASE_URL = process.env.PRODUCTION_DATABASE_URL
  DATABASE_PORT = process.env.PRODUCTION_DATABASE_PORT
  DATABASE_NAME = process.env.PRODUCTION_DATABASE_NAME
  DATABASE_USER = process.env.PRODUCTION_DATABASE_USER
  DATABASE_PASSWORD = process.env.PRODUCTION_DATABASE_PASSWORD
}


// Email Settings
const EMAIL_CONFIG = {
  host: process.env.EMAIL_HOST, /* From ENV */
  port: process.env.EMAIL_PORT || 587,
  email: process.env.EMAIL_USER || '<YOUR SMTP LOGIN EMAIL',
  sender: process.env.EMAIL_SENDER || '<YOUR SMTP SENDER NAME',
  senderEmail: process.env.EMAIL_SENDEREMAIL || '<YOUR SMTP SENDER EMAIL',
  password: process.env.EMAIL_PASSWORD, /* FROM ENV */
  // secure: process.env.SMTP_SECURE || false,
  // tls: process.env.SMTP_TLS || false,
};

const AUTH = {
  jwt: {
    secret: process.env.JWT_SECRET,
    expiresIn: process.env.JWT_EXPIRES_IN
  },
};


module.exports = {
  PORT,
  API_VERSION,
  AUTH,
  EMAIL_CONFIG,
  DATABASE_NAME,
  DATABASE_PASSWORD,
  DATABASE_URL,
  DATABASE_USER,
  DATABASE_PORT,
  CLOUD_NAME,
  CLOUD_API_KEY,
  CLOUD_API_SECRET
}
