/** @format */
/** @format */
const {
  createDoc,
  getDocs,
  updateDoc,
  deleteDoc
} = require('@helpers/factoryFN');
const { validateStory, Story } = require('../model/story');
const { _responseWrapper } = require('@helpers/util-response');
const {
  baseUrlGenerator
} = require('@middleware/fileUploadMiddleware');


// get all storys Routes
exports.getAllStory = async req => {
  let query = {
    expiry: { $gt: Date.now() }
  }
  return await getDocs(Story, { query })(req);
};

exports.getStory = async req => {
  try {
    let storyData = await getDocs(Story)(req);
    if (storyData.statusCode == 200) {
      let { data: story } = storyData.response
      if (story.user.toString() !== req.userId) {
        await story.markAsWatched(req.userId)
      }
    }
    let restParams = {
      populate: {
        path: "watchedBy.user",
        model: 'User',
        select: 'name'
      }
    }
    return await getDocs(Story, restParams)(req);
  } catch (error) {
    console.log(error)
  }
};


exports.updateStory = async req => {
  try {
    if (req.file) {
      req.body['media'] = [baseUrlGenerator(req)];
    }
    else
      delete req.body['media']

    let updateObject = {
      update: {
        $set: { ...req.body }
      }
    }
    return updateDoc(Story, { updateObject })(req);
  } catch (err) {
    console.log(err)
  }
};

exports.deleteStory = deleteDoc(Story);

exports.createStory = async req => {
  try {
    if (req.file)
      req.body['media'] = [baseUrlGenerator(req)];
    else
      delete req.body['media']

    const expiryDate = new Date();
    expiryDate.setHours(expiryDate.getHours() + 24);
    req.body['user'] = req.user._id.toString()
    req.body['expiry'] = expiryDate



    const story = await createDoc(Story, {
      returnDoc: true,
      validateFN: validateStory
    })(req);

    if (!story.status) {
      if (story.statusCode === 400)
        return story
      return _responseWrapper(true, story.error.message, 400);
    }

    return _responseWrapper(false, 'Story has been created', 201, {
      data: story.data
    });
  } catch (error) {
    console.log('error', error.message);
  }
};