/** @format */
/** @format */
// const jwt = require('jsonwebtoken');
const crypto = require('crypto');
const config = require('@root/config');
const { ObjectId } = require('mongoose').Types;
// const { promisify } = require('util');
const { cacheInstance, removeSession } = require('@helpers/util-Cache');
const { generateJWTToken } = require("@helpers/util-utilities");
const {
  createDoc,
  getDocs,
  updateDoc,
  deleteDoc
} = require('@helpers/factoryFN');
const { validatePost, Post } = require('../model/post');
const { _responseWrapper, _res } = require('@helpers/util-response');
const { sendEmail, isValidEmail } = require('../../../utils/email');
const {
  baseUrlGenerator
} = require('@middleware/fileUploadMiddleware');
const _ = require('lodash');
const { validTokenStr } = require('../../../middleware/authenticationMiddleware');



// get all posts Routes
exports.getAllPost = async req => {
  return await getDocs(Post)(req);
};

exports.getPost = async req => {
  return await getDocs(Post)(req);
};

exports.updatePost = async req => {
  try {
    if (req.file) {
      req.body['media'] = [baseUrlGenerator(req)];
    }
    else
      delete req.body['media']

    let updateObject = {
      update: {
        $set: { ...req.body }
      }
    }
    return updateDoc(Post, { updateObject })(req);
  } catch (err) {
    console.log(err)
  }
};

exports.deletePost = deleteDoc(Post);

exports.createPost = async req => {
  try {
    if (req.file)
      req.body['media'] = [baseUrlGenerator(req)];
    else
      delete req.body['media']

    console.log(req.body)

    req.body['user'] = req.user._id.toString()

    const post = await createDoc(Post, {
      returnDoc: true,
      validateFN: validatePost
    })(req);

    if (!post.status) {
      if (post.statusCode === 400)
        return post
      return _responseWrapper(true, post.error.message, 400);
    }

    return _responseWrapper(false, 'Post has been created', 201, {
      data: post.data
    });
  } catch (error) {
    console.log('error', error.message);
  }
};