/** @format */

const { routesHandler } = require('../../../helpers/util-generic-functions');
const {
  createLike,
  removeLike,
  getLikes
} = require('../controller/like');
const { protect } = require('../../../middleware/authenticationMiddleware');

const story = router => {
  // Like Routes
  router.post(`/like/create`, protect, routesHandler(createLike));
  router.put(`/like/remove/:id`, protect, routesHandler(removeLike));
  router.get(`/likes`, protect, routesHandler(getLikes));
};

module.exports = story;
