/** @format */
/** @format */

const {
  createDoc,
  getDocs,
} = require('@helpers/factoryFN');
const { validateLike, Like } = require('../model/like');
const { _responseWrapper } = require('@helpers/util-response');


exports.createLike = async (req) => {
  req.body['user'] = req.userId
  const like = await createDoc(Like, {
    returnDoc: true,
    validateFN: validateLike
  })(req);

  if (!like.status) {
    if (like.statusCode === 400)
      return like
    return _responseWrapper(true, like.error.message, 400);
  }

  return _responseWrapper(false, `You have liked the ${req.body.itemType}`, 201, {
    data: like.data
  });
}

exports.removeLike = async (req) => {
  let removed = await Like.findByIdAndDelete(req.params.id)
  if (removed)
    return _responseWrapper(false, `You have remove the like`, 200)
  else
    return _responseWrapper(true, `Like not found`, 404)
}

exports.getLikes = async (req) => {
  let query = {
    itemId: req.body.itemId
  }
  let populate = {
    path: 'user',
    model: 'User',
    select: 'name avatar'
  }
  let select = '-_id -itemId -itemType -createdBy -createdAt -__v -isDeleted'
  return await getDocs(Like, { query, populate, select })(req)
}
