/* eslint-disable no-restricted-syntax */
/** @format */

const mongoose = require('mongoose');

const { convert } = require('joigoose')(mongoose);
const Joi = require('joi');
const baseSchema = require('../../baseSchema');

const commentJoigooseSchema = Joi.object({
  user: Joi.string().required().meta({
    _mongoose: { type: 'ObjectId', ref: 'User' }
  }),
  itemId: Joi.string().required().meta({
    _mongoose: { type: 'ObjectId', ref: 'Post' }
  }),
  itemType: Joi.string().required().valid('Post', 'Comment'),
  description: Joi.string().required().min(1).max(500),
  ...baseSchema
});

let commentSchema = convert(commentJoigooseSchema);

commentSchema.user = {
  type: mongoose.Schema.Types.ObjectId,
  ref: 'User'
};

commentSchema.itemId = {
  type: mongoose.Schema.Types.ObjectId,
  ref: 'Post'
};


commentSchema = new mongoose.Schema(commentSchema);





const Comment = mongoose.model('Comment', commentSchema);



// validate the comment input by passing it to joigoose schema
const validateComment = commentData => commentJoigooseSchema.validate(commentData);

module.exports = {
  Comment,
  validateComment
};
