/** @format */

const { routesHandler } = require('../../../../helpers/util-generic-functions');
const {
  createMessage,
  getMessages,
  deleteMessage
} = require('../controller/message');
const { upload, prepareAndUpload } = require('../../../../middleware/fileUploadMiddleware');
const { protect } = require('../../../../middleware/authenticationMiddleware');

const post = router => {
  // Post Routes
  router.post(`/message/create`, protect, upload.single('media'), prepareAndUpload, routesHandler(createMessage));
  router.get(`/messages`, protect, routesHandler(getMessages));
  router.put(`/message/delete/:id`, protect, routesHandler(deleteMessage));

};

module.exports = post;
