/* eslint-disable no-restricted-syntax */
/** @format */

const mongoose = require('mongoose');

const { convert } = require('joigoose')(mongoose);
const Joi = require('joi');
const baseSchema = require('../../../baseSchema');

const messageJoigooseSchema = Joi.object({
  chat: Joi.string().required().meta({
    _mongoose: { type: 'ObjectId', ref: 'Chat' }
  }).required(),
  sender: Joi.string().required().meta({
    _mongoose: { type: 'ObjectId', ref: 'User' }
  }),
  content: Joi.string().required().max(500),
  media: Joi.array()
    .items(Joi.object({
      type: Joi.string(),
      size: Joi.number(),
      filename: Joi.string(),
      url: Joi.string()
    })),
  isRead: Joi.boolean().default(false),
  readAt: Joi.date().optional(),
  ...baseSchema
});

let messageSchema = convert(messageJoigooseSchema);

messageSchema.chat = {
  type: mongoose.Schema.Types.ObjectId,
  ref: 'Chat'
};
messageSchema.sender = {
  type: mongoose.Schema.Types.ObjectId,
  ref: 'User'
};


messageSchema = new mongoose.Schema(messageSchema);


const Message = mongoose.model('Message', messageSchema);

// validate the message input by passing it to joigoose schema
const validateMessage = messageData => messageJoigooseSchema.validate(messageData);

module.exports = {
  Message,
  validateMessage
};
